#include "c4d_memory.h"
#include "c4d_general.h"
#include "c4d_tools.h"
#include "c4d_basebitmap.h"
#include "c4d_tagplugin.h"
#include "c4d_file.h"
#include "c4d_resource.h"

Bool TagData::Draw(PluginTag *tag, BaseObject *op, BaseDraw *bd, BaseDrawHelp *bh)
{
	return TRUE;
}

LONG TagData::Execute(PluginTag *tag, BaseDocument *doc, BaseObject *op, BaseThread *bt, LONG priority, LONG flags)
{
	return EXECUTION_RESULT_OK;
}

Bool TagData::AddToExecution(PluginTag *tag, PriorityList *list)
{
	return FALSE;
}

static void FillTagPlugin(TAGPLUGIN *np, DataAllocator *npalloc, LONG info, LONG disklevel, BaseBitmap *icon, void *emulation)
{
	FillNodePlugin(np,info,npalloc,icon,disklevel,emulation);

	np->Draw								= &TagData::Draw;
	np->Execute							= &TagData::Execute;
	np->AddToExecution			= &TagData::AddToExecution;
}

Bool RegisterTagPlugin(LONG id, const String &str, LONG info, DataAllocator *npalloc, const String &description, const String &iconname, LONG disklevel)
{
	Bool ok=FALSE;

	AutoAlloc<BaseBitmap> icon;

	if (icon && icon->Init(GeGetPluginPath()+String("res")+iconname)==IMAGE_OK)
		ok=RegisterTagPlugin(id,str,info,npalloc,description,icon,disklevel);

	return ok;
}

Bool RegisterTagPlugin(LONG id, const String &str, LONG info, DataAllocator *npalloc, const String &description, LONG disklevel)
{
	return RegisterTagPlugin(id,str,info,npalloc,description,NULL,disklevel,NULL);
}

Bool RegisterTagPlugin(LONG id, const String &str, LONG info, DataAllocator *npalloc, const String &description, BaseBitmap *icon, LONG disklevel, void *emulation)
{
	if (description.Content() && !RegisterDescription(id,description)) return FALSE;

	TAGPLUGIN np;
	ClearMem(&np,sizeof(np));
	FillTagPlugin(&np,npalloc,info,disklevel,icon,emulation);
	return GeRegisterPlugin(C4DPL_TAG,id,str,&np,sizeof(np));
}
